% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root.R
\name{root}
\alias{root}
\title{One Dimensional Root (Zero) Finding}
\usage{
root(
  f,
  lower,
  upper,
  maxerror_f = 1e-07,
  f_lower = f(lower, ...),
  f_upper = f(upper, ...),
  tol = .Machine$double.eps^0.25,
  convexity = FALSE,
  rec = 0,
  max.rec = NA,
  ...
)
}
\arguments{
\item{f}{the function for which the root is sought.}

\item{lower}{the lower end point of the interval to be searched.}

\item{upper}{the upper end point of the interval to be searched.}

\item{maxerror_f}{the maximum error on f evaluation (iterates over uniroot to converge).}

\item{f_lower}{the same as f(lower).}

\item{f_upper}{the same as f(upper).}

\item{tol}{the desired accuracy (convergence tolerance on f arg).}

\item{convexity}{the learned convexity factor of the function, used to reduce the boundaries for uniroot.}

\item{rec}{counter of recursive level.}

\item{max.rec}{maximal number of recursive level before failure (stop).}

\item{...}{additional named or unnamed arguments to be passed to f.}
}
\description{
Search one root with given precision (on y). Iterate over uniroot as long as necessary.
}
\examples{
f=function(x) {cat("f");1-exp(x)}; f(root(f,lower=-1,upper=2))
f=function(x) {cat("f");exp(x)-1}; f(root(f,lower=-1,upper=2))

.f = function(x) 1-exp(1*x)
f=function(x) {cat("f");y=.f(x);points(x,y,pch=20,col=rgb(0,0,0,.2));y}
plot(.f,xlim=c(-1,2)); f(root(f,lower=-1,upper=2))

.f = function(x) exp(10*x)-1
f=function(x) {cat("f");y=.f(x);points(x,y,pch=20);y}
plot(.f,xlim=c(-1,2)); f(root(f,lower=-1,upper=2))

.f = function(x) exp(100*x)-1
f=function(x) {cat("f");y=.f(x);points(x,y,pch=20);y}
plot(.f,xlim=c(-1,2)); f(root(f,lower=-1,upper=2))

f=function(x) {cat("f");exp(100*x)-1}; f(root(f,lower=-1,upper=2))

\dontrun{

  # Quite hard functions to find roots

  ## Increasing function
  ## convex
  n.f=0
  .f = function(x) exp(10*x)-1
  f=function(x) {n.f<<-n.f+1;y=.f(x);points(x,y,pch=20);y}
  plot(.f,xlim=c(-.1,.2)); f(root(f,lower=-1,upper=2))
  print(n.f)
  ## non-convex
  n.f=0
  .f = function(x) 1-exp(-10*x)
  f=function(x) {n.f<<-n.f+1;y=.f(x);points(x,y,pch=20);y}
  plot(.f,xlim=c(-.1,.2)); f(root(f,lower=-1,upper=2))
  print(n.f)

  # ## Decreasing function
  # ## non-convex
  n.f=0
  .f = function(x) 1-exp(10*x)
  f=function(x) {n.f<<-n.f+1;y=.f(x);points(x,y,pch=20,col=rgb(0,0,0,.2));y}
  plot(.f,xlim=c(-.1,.2)); f(root(f,lower=-1,upper=2))
  print(n.f)
  # ## convex
  n.f=0
  .f = function(x) exp(-10*x)-1
  f=function(x) {n.f<<-n.f+1;y=.f(x);points(x,y,pch=20,col=rgb(0,0,0,.2));y}
  plot(.f,xlim=c(-.1,.2)); f(root(f,lower=-1,upper=2))
  print(n.f)
}
}
\author{
Yann Richet, IRSN
}
