## -----------------------------------------------------------------------------
#| code-fold: true
#| code-summary: "Environment on author's computer"
Sys.info()[c('sysname', 'release', 'machine')]
R.version


## -----------------------------------------------------------------------------
#| eval: false
# remotes::install_github('tingtingzhan/DemographicTable')


## -----------------------------------------------------------------------------
#| eval: false
# utils::install.packages('DemographicTable')


## -----------------------------------------------------------------------------
library(DemographicTable)
library(flextable)


## -----------------------------------------------------------------------------
datasets::penguins |>
  DemographicTable(include = c('species', 'island', 'bill_len')) |> 
  as_flextable()


## -----------------------------------------------------------------------------
datasets::penguins |>
  DemographicTable(groups = 'sex', include = c('species', 'bill_dep')) |> 
  as_flextable()


## -----------------------------------------------------------------------------
datasets::penguins |>
  DemographicTable(groups = 'sex', include = c('species', 'bill_dep'), compare = FALSE) |>
  as_flextable()


## -----------------------------------------------------------------------------
datasets::penguins |>
  DemographicTable(groups = c('sex', 'island'), include = c('species', 'bill_dep'), compare = FALSE) |> 
  as_flextable()


## -----------------------------------------------------------------------------
tb1 = datasets::penguins |>
  subset(subset = (sex == 'male')) |>
  DemographicTable(groups = 'island', include = c('species', 'bill_dep'), data.name = 'Male Penguins', compare = FALSE)


## -----------------------------------------------------------------------------
tb2 = datasets::penguins |>
  subset(subset = (sex == 'female')) |>
  DemographicTable(groups = 'island', include = c('species', 'bill_dep'), data.name = 'Female Penguins', compare = FALSE)


## -----------------------------------------------------------------------------
c(tb1, tb2) |> as_flextable()


## -----------------------------------------------------------------------------
datasets::penguins |>
  DemographicTable(groups = c('sex'), include = c('body_mass', 'species')) |>
  as_flextable()


## -----------------------------------------------------------------------------
mtc = datasets::mtcars |>
  within.data.frame(expr = {
    vs_straight = as.logical(vs)
    am_manual = as.logical(am)
  })


## -----------------------------------------------------------------------------
tryCatch(DemographicTable(mtc, groups = 'am_manual', include = c('drat', 'vs_straight')), warning = identity)


## -----------------------------------------------------------------------------
#| warning: false
mtc |>
  DemographicTable(groups = 'am_manual', include = c('drat', 'vs_straight')) |>
  as_flextable()


## -----------------------------------------------------------------------------
mtcars |>
  within.data.frame(expr = {
    vs = ifelse(vs, yes = 'Straight', no = 'V-shaped')
    am = ifelse(am, yes = 'manual', no = 'automatic')
  }) |> 
  DemographicTable(groups = 'am', include = c('drat', 'vs'), data.name = 'mtcars') |>
  as_flextable()

