% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin_time_variant.R
\name{kin_time_variant}
\alias{kin_time_variant}
\title{Estimate kin counts in a time variant framework (dynamic rates) for one-sex model (matrilineal/patrilineal)}
\usage{
kin_time_variant(
  p = NULL,
  f = NULL,
  pi = NULL,
  n = NULL,
  output_cohort = NULL,
  output_period = NULL,
  output_kin = NULL,
  birth_female = 1/2.04,
  list_output = FALSE
)
}
\arguments{
\item{p}{numeric. A matrix of survival ratios with rows as ages and columns as years. Column names must be equal interval.}

\item{f}{numeric. A matrix of age-specific fertility rates with rows as ages and columns as years. Coincident with \code{U}.}

\item{pi}{numeric. A matrix with distribution of childbearing with rows as ages and columns as years. Coincident with \code{U}.}

\item{n}{numeric. A matrix of population with rows as ages and columns as years. Coincident with \code{U}.}

\item{output_cohort}{integer. Year of birth of focal to return as output. Could be a vector. Should be within input data years range.}

\item{output_period}{integer. Year for which to return kinship structure. Could be a vector. Should be within input data years range.}

\item{output_kin}{character. kin to return as output: "m" for mother, "d" for daughter,... See \code{vignette} for exahustive kin.}

\item{birth_female}{numeric. Female portion at birth.}

\item{list_output}{logical. Results as a list with years elements (as a result of \code{output_cohort} and \code{output_period} combination), with a second list of \code{output_kin} elements, with focal´s age in columns and kin ages in rows (2 * ages, last chunk of ages for death experience). Default \code{FALSE}}
}
\value{
A data frame of population kinship structure, with Focal's cohort, focal´s age, period year, type of relatives
(for example \code{d} is daughter, \code{oa} is older aunts, etc.), living and death kin counts, and age of (living or time deceased) relatives. If \code{list_output = TRUE} then this is a list.
}
\description{
Matrix implementation of time variant Goodman-Keyfitz-Pullum equations in a matrix framework.
}
\details{
See Caswell (2021) for details on formulas.
}
