/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.SyntaxArea;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class ComputeDialog
extends JDialog
implements ActionListener,
MouseListener {
    private VariableSelector variableSelector;
    private JPanel computePanel;
    private JScrollPane computeScroller;
    private JTextField subName;
    private JButton logicLT;
    private JLabel recentLabel;
    private JComboBox recent;
    private JButton help;
    private JButton funcHelp;
    private JButton logicEQ;
    private JButton logicNE;
    private JButton logicNot;
    private JButton logicOr;
    private JButton logicAnd;
    private JButton logicGT;
    private JButton logicLTE;
    private JButton logicGTE;
    private JList funcList;
    private JScrollPane funcScroller;
    private JPanel funcPanel;
    private JPanel logPanel;
    private JLabel jLabel1;
    private SyntaxArea computeEditor;
    private OkayCancelPanel okcan;
    public static HashMap historyMap;
    private static String lastDataName;

    public ComputeDialog(JFrame jFrame) {
        super(jFrame);
        if (historyMap == null) {
            historyMap = new HashMap();
        }
        this.initGUI();
        if (lastDataName != null) {
            this.variableSelector.setSelectedData(lastDataName);
        }
        this.refreshRecent();
    }

    public void refreshRecent() {
        ArrayList arrayList = (ArrayList)historyMap.get(this.variableSelector.getSelectedData());
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        this.recent.setModel(defaultComboBoxModel);
        defaultComboBoxModel.addElement("");
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                defaultComboBoxModel.addElement((String)arrayList.get(i));
            }
        }
    }

    public static DefaultComboBoxModel getRecent(String string) {
        if (historyMap == null) {
            historyMap = new HashMap();
        }
        ArrayList arrayList = (ArrayList)historyMap.get(string);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                defaultComboBoxModel.addElement((String)arrayList.get(i));
            }
        }
        return defaultComboBoxModel;
    }

    public void setDataName(String string, boolean bl) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public static void addToHistory(String string, String string2) {
        if (string2.trim().length() == 0) {
            return;
        }
        if (historyMap.containsKey(string)) {
            ((ArrayList)historyMap.get(string)).add(0, string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            historyMap.put(string, arrayList);
        }
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.funcPanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.funcPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.funcPanel);
            this.funcPanel.setPreferredSize(new Dimension(140, 173));
            this.funcPanel.setBorder(BorderFactory.createTitledBorder("Functions"));
            this.funcPanel.setBounds(233, 112, 140, 173);
            this.funcScroller = new JScrollPane();
            this.funcPanel.add((Component)this.funcScroller, "Center");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{"log", "sqrt", "abs", "mean", "median", "sd", "pmax", "pmin", "round"});
            this.funcList = new JList();
            this.funcScroller.setViewportView(this.funcList);
            this.funcList.setModel(defaultComboBoxModel);
            this.funcList.addMouseListener(this);
            this.funcList.setSelectionMode(0);
            this.logPanel = new JPanel();
            this.getContentPane().add(this.logPanel);
            this.logPanel.setPreferredSize(new Dimension(126, 173));
            this.logPanel.setBorder(BorderFactory.createTitledBorder("Operators"));
            this.logPanel.setLayout(null);
            this.logPanel.setBounds(379, 112, 126, 173);
            this.logicGTE = new JButton();
            this.logPanel.add(this.logicGTE);
            this.logicGTE.setText("*");
            this.logicGTE.setBounds(12, 19, 46, 21);
            this.logicGTE.addActionListener(this);
            this.logicLTE = new JButton();
            this.logPanel.add(this.logicLTE);
            this.logicLTE.setText("/");
            this.logicLTE.setBounds(69, 19, 46, 21);
            this.logicLTE.addActionListener(this);
            this.logicGT = new JButton();
            this.logPanel.add(this.logicGT);
            this.logicGT.setText("+");
            this.logicGT.setBounds(12, 45, 46, 21);
            this.logicGT.addActionListener(this);
            this.logicLT = new JButton();
            this.logPanel.add(this.logicLT);
            this.logicLT.setText("-");
            this.logicLT.setBounds(69, 45, 46, 21);
            this.logicLT.addActionListener(this);
            this.logicAnd = new JButton();
            this.logPanel.add(this.logicAnd);
            this.logicAnd.setText("( )");
            this.logicAnd.setBounds(32, 96, 62, 20);
            this.logicAnd.addActionListener(this);
            this.logicOr = new JButton();
            this.logPanel.add(this.logicOr);
            this.logicOr.setText("^4");
            this.logicOr.setBounds(32, 121, 62, 21);
            this.logicOr.addActionListener(this);
            this.logicNot = new JButton();
            this.logPanel.add(this.logicNot);
            this.logicNot.setText("^5");
            this.logicNot.setBounds(32, 147, 62, 21);
            this.logicNot.addActionListener(this);
            this.logicNE = new JButton();
            this.logPanel.add(this.logicNE);
            this.logicNE.setText("^3");
            this.logicNE.setBounds(69, 70, 46, 21);
            this.logicNE.addActionListener(this);
            this.logicEQ = new JButton();
            this.logPanel.add(this.logicEQ);
            this.logicEQ.setText("^2");
            this.logicEQ.setBounds(12, 70, 46, 21);
            this.logicEQ.addActionListener(this);
            this.jLabel1 = new JLabel();
            this.getContentPane().add(this.jLabel1);
            this.jLabel1.setText("New Variable:");
            this.jLabel1.setPreferredSize(new Dimension(88, 14));
            this.jLabel1.setBounds(12, 218, 88, 14);
            this.subName = new JTextField();
            this.getContentPane().add(this.subName);
            this.subName.setText("");
            this.subName.setBounds(100, 215, 102, 21);
            this.computePanel = new JPanel();
            serializable = new BorderLayout();
            this.computePanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.computePanel);
            this.computePanel.setBorder(BorderFactory.createTitledBorder("Compute Expression"));
            this.computePanel.setBounds(233, 12, 272, 74);
            this.computeScroller = new JScrollPane();
            this.computePanel.add((Component)this.computeScroller, "Center");
            this.computeScroller.setPreferredSize(new Dimension(262, 52));
            this.computeEditor = new SyntaxArea();
            this.computeScroller.setViewportView((Component)this.computeEditor);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add(this.variableSelector);
            this.variableSelector.setPreferredSize(new Dimension(215, 194));
            this.variableSelector.setBounds(12, 12, 215, 194);
            this.variableSelector.getJComboBox().addActionListener(this);
            this.variableSelector.getJList().addMouseListener(this);
            this.okcan = new OkayCancelPanel(true, false, this);
            this.getContentPane().add(this.okcan);
            this.okcan.setBounds(230, 297, 270, 40);
            this.funcHelp = new IconButton("/icons/help.png", "Function Help", this, "Function Help");
            this.getContentPane().add(this.funcHelp);
            this.funcHelp.setBounds(202, 254, 31, 31);
            this.help = new HelpButton("pmwiki.php?n=Main.Compute");
            this.getContentPane().add(this.help);
            this.help.setBounds(12, 297, 35, 35);
            serializable = new DefaultComboBoxModel();
            this.recent = new JComboBox();
            this.getContentPane().add(this.recent);
            this.recent.setModel(serializable);
            this.recent.setBounds(287, 87, 218, 21);
            this.recent.addActionListener(this);
            this.recentLabel = new JLabel();
            this.getContentPane().add(this.recentLabel);
            this.recentLabel.setText("Recent:");
            this.recentLabel.setBounds(237, 90, 54, 14);
            this.setTitle("Compute Variable");
            this.setResizable(false);
            this.setSize(525, 375);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object e;
        String string = actionEvent.getActionCommand();
        if (string == "*") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), " * ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "/") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), " / ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "^2") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), "^2 ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "^3") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), "^3 ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "( )") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), "( )", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "+") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), " + ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "-") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), " - ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "^4") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), "^4 ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "^5") {
            try {
                this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), "^5 ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.computeEditor.requestFocus();
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            String string2 = this.computeEditor.getText();
            String string3 = this.variableSelector.getSelectedData();
            String string4 = this.computeEditor.getText();
            if (!ComputeDialog.isValidComputeExp(string4, string3)) {
                JOptionPane.showMessageDialog(this, "Invalid Compute. Please enter a compute expression");
                return;
            }
            if (this.subName.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Please enter a variable name");
                return;
            }
            String string5 = RController.makeValidVariableName((String)this.subName.getText());
            Deducer.execute(string3 + "[[\"" + string5 + "\"]] <- with(" + string3 + "," + string4 + ")");
            ComputeDialog.addToHistory(this.variableSelector.getSelectedData(), string4);
            lastDataName = this.variableSelector.getSelectedData();
            Deducer.setRecentData(string3);
            this.dispose();
        } else if (string == "Reset") {
            this.computeEditor.setText("");
            this.subName.setText("");
            this.computeEditor.requestFocus();
        } else if (string == "comboBoxChanged") {
            if (actionEvent.getSource() == this.recent) {
                this.computeEditor.setText((String)this.recent.getSelectedItem());
                this.computeEditor.requestFocus();
            } else {
                this.computeEditor.setText("");
                this.refreshRecent();
            }
        } else if (string == "Function Help" && (e = this.funcList.getSelectedValue()) != null) {
            Deducer.execute("help(\"" + (String)e + "\")", false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            String string = "";
            if (mouseEvent.getSource() == this.funcList) {
                string = (String)this.funcList.getSelectedValue();
                try {
                    this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), string + "() ", null);
                    this.computeEditor.requestFocus();
                    this.computeEditor.setCaretPosition(this.computeEditor.getCaretPosition() - 2);
                }
                catch (Exception exception) {}
            } else {
                string = (String)this.variableSelector.getJList().getSelectedValue();
                try {
                    this.computeEditor.getDocument().insertString(this.computeEditor.getCaretPosition(), string, null);
                    this.computeEditor.requestFocus();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static boolean isValidComputeExp(String string, String string2) {
        if (string == null || string.length() < 1) {
            return false;
        }
        REXP rEXP = null;
        rEXP = Deducer.timedEval("(function(x,compute){result<-try(e <- substitute(compute),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nresult<-try(r <- eval(e, x, parent.frame()),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nTRUE\n})(" + string2 + "," + string + ")");
        if (rEXP == null) {
            return false;
        }
        if (!rEXP.isLogical()) {
            return false;
        }
        return ((REXPLogical)rEXP).isTRUE()[0];
    }
}

