% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1Create_large_gaps.R
\name{gapCreation}
\alias{gapCreation}
\title{Gap creation}
\usage{
gapCreation(X, rate, begin = NULL)
}
\arguments{
\item{X}{input vector}

\item{rate}{size of desired gap, as a percentage of input vector size}

\item{begin}{location of the begining of the gap (random by default)}
}
\value{
gapCreation returns a list containing the following elements:
\itemize{
 \item{output_vector: }{output vector containing the created gap}
 \item{input_vector: }{original vector used as input}
 \item{begin_gap: }{index of the begining of the gap}
 \item{rate: }{size of the created gap in percentage of the input vector length}
 \item{gap_size: }{length of the created gap}
}
}
\description{
This function creates a large continuous gap within a univariate signal.
Gap size is defined as a percentage of input vector length.
By default, the created gap starts at a random location.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1]
rate <- 0.1
output <- gapCreation(X, rate)
plot(output$input_vector, type = "l", col = "red", lwd = 2)
lines(output$output_vector, lty = "dashed", lwd = 2)
}
\author{
Camille Dezecache, Hong T. T. Phan, Emilie Poisson-Caillault
}
