%  file man/AirQuality.Rd
%  Documentation for the AirQuality dataset
%---------------------
\name{AirQuality}
\alias{AirQuality}
\docType{data}
\encoding{UTF-8}
\title{Air Quality Data Set (UCI)}

\description{
  Measurements of air quality variables in an Italian city collected over several months in 2004--2005.
  The data includes hourly averaged responses from chemical sensors embedded in an air quality chemical multi-sensor device.
}

\usage{data(AirQuality)}

\format{
  A data frame with 9358 observations on the following 15 variables. Some variable names use parentheses, which may need to be quoted with backticks in R.
  \itemize{
    \item \code{Date}: Date (in DD/MM/YYYY format)
    \item \code{Time}: Time (in HH.MM.SS format)
    \item \code{CO.GT.}: Carbon Monoxide concentration (mg/m³)
    \item \code{PT08.S1.CO.}: Sensor 1 response
    \item \code{NMHC.GT.}: Non-methane hydrocarbons (µg/m³)
    \item \code{C6H6.GT.}: Benzene concentration (µg/m³)
    \item \code{PT08.S2.NMHC.}: Sensor 2 response
    \item \code{NOx.GT.}: Nitric oxide concentration (ppb)
    \item \code{PT08.S3.NOx.}: Sensor 3 response
    \item \code{NO2.GT.}: Nitrogen dioxide concentration (µg/m³)
    \item \code{PT08.S4.NO2.}: Sensor 4 response
    \item \code{PT08.S5.O3.}: Sensor 5 response
    \item \code{T}: Temperature (°C)
    \item \code{RH}: Relative Humidity (\%)
    \item \code{AH}: Absolute Humidity
  }
  Some variables contain missing values coded as -200.
}

\details{
  The dataset contains air quality data recorded in a densely populated area of an Italian city between March 2004 and February 2005.
  The data were collected using an array of chemical sensors and meteorological instruments.

  This dataset is frequently used for tasks such as missing value imputation, time series analysis, regression, and machine learning model evaluation.
}

\source{
  De Vito, S., Massera, E., Piga, M., Martinotto, L., & Di Francia, G. (2008).\\
  \emph{UCI Machine Learning Repository: Air Quality Data Set}.\\
  Available at: \url{https://archive.ics.uci.edu/ml/datasets/Air+Quality}
}

\references{
  De Vito, S., Massera, E., Piga, M., Martinotto, L., & Di Francia, G. (2008).\\
  Semi-Supervised Learning Techniques in Artificial Olfaction: A Novel Approach to Classification Problems and Drift Counteraction.\\
  \emph{IEEE Sensors Journal}, \bold{8}(12), 2030--2038.
}

\examples{
data(AirQuality)

# Replace missing values (-200) with NA
AirQuality[AirQuality == -200] <- NA

# Check if there are non-NA values before plotting
if (sum(!is.na(AirQuality$CO.GT.)) > 0) {
  plot(AirQuality$CO.GT., type = "l", ylab = "CO (mg/m³)",
       main = "Hourly CO Concentration")
} else {
  message("No non-NA values in CO.GT. column to plot")
}
}
\keyword{datasets}
