% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_predictive.R
\name{prior_predictive}
\alias{prior_predictive}
\title{Prior Predictive Check}
\usage{
prior_predictive(
  dis_matrix,
  model_name = c("UU", "EU", "UD", "ED", "US", "ES"),
  p = 2,
  trunc_value = 15,
  hyper_params = NULL,
  scale = TRUE,
  nsim = 1000,
  plot = TRUE
)
}
\arguments{
\item{dis_matrix}{A distance structure such as that returned by \link[stats:dist]{stats::dist} or a full symmetric matrix containing the dissimilarities.}

\item{model_name}{The DPCD model from which to draw prior predictive samples. Must be one of "UU", "EU", "UD", "ED", "US", or "ES".}

\item{p}{The dimension of the space in which the objects are embedded. Must be at least 2.}

\item{trunc_value}{The truncation level for the stick-breaking representation of the Dirichlet process.}

\item{hyper_params}{A named list of hyperparameter values. See details for more information.}

\item{scale}{Logical argument indicating whether to scale the dissimilarities so that the maximum value is 1.}

\item{nsim}{Number of datasets to simulate from the prior predictive distribution.}

\item{plot}{Logical argument indicating whether to plot the simulated dissimilarities against the observed dissimilarities. See details for more information.}
}
\value{
A matrix of simulated dissimilarities from the prior predictive distribution with \code{nsim} rows and \code{n * (n-1) / 2} columns, where \code{n} is the number of objects (i.e. the number of rows/columns of \code{dis_matrix}).
}
\description{
This function simulates dissimilarities from the prior predictive distribution of a specified DPCD model and optionally plots the density of the simulated dissimilarities against the observed dissimilarities.
}
\details{
A prior predictive check is used to assess if datasets drawn from the prior predictive distribution are consistent with the observed data. Most of the mass of the prior predictive distribution should be placed on plausible values of the dissimilarities, while little or no mass should be placed on implausible values.

If \code{plot = TRUE}, a plot is created to compare the density of the observed dissimilarities to the densities of the dissimilarities simulated from the prior predictive distribution using \code{bayesplot::ppc_dens_overlay()}.

See \code{\link[=run_dpcd]{run_dpcd()}} for details on the DPCD models and hyperparameters.
}
\examples{
\donttest{
ppc <- prior_predictive(dis_mat_example, "UU", p = 2, nsim = 100, plot = TRUE)
}

}
\references{
Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., & Gelman, A. (2019).
Visualization in Bayesian workflow. Journal of the Royal Statistical Society A,
182(2), 389–402. https://doi.org/10.1111/rssa.12378
}
\seealso{
\code{\link[=run_dpcd]{run_dpcd()}}
}
