% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_objects.R
\name{plot_objects}
\alias{plot_objects}
\title{Plot the Object Configuration}
\usage{
plot_objects(mcmc_samples, target_matrix, show_clusters = TRUE, ...)
}
\arguments{
\item{mcmc_samples}{An object of class \code{mcmc} or \code{mcmc.list} containing posterior samples from a DPCD model fit using \code{\link[=run_dpcd]{run_dpcd()}}. Variable \code{x} must be included in the output parameters.}

\item{target_matrix}{A matrix used as the target for aligning the posterior latent coordinates (\code{x}) via a Procrustes transformation.}

\item{show_clusters}{Logical argument indicating whether to colour points by their cluster membership. If \code{TRUE}, then \code{z} must be included in \code{mcmc_samples}.}

\item{...}{Additional arguments to be passed to \code{plot()} (2 dimensions) or \code{pairs()} (higher dimensions).}
}
\value{
A scatter plot (for 2-dimensional latent space) or pairs plot (for higher dimensions) of the object configuration.
}
\description{
Generates a plot of the posterior mean of the latent coordinates (\code{x}) from a DPCD model fit, aligned to a specified target matrix using a Procrustes transformation.
}
\details{
Since the latent coordinates are non-identifiable due to invariance of Euclidean distances to rotation, reflection, and translation, this function first aligns the posterior samples of \code{x} to a specified target matrix using a Procrustes transformation. Then, it computes the posterior mean of the aligned latent coordinates and generates a plot. If \code{show_clusters} is set to \code{TRUE}, points are coloured according to their cluster memberships, which is estimated through maximizing the posterior expected adjusted Rand index (Fritsch and Ickstadt, 2009).
}
\examples{
target_matrix <- cmdscale(dis_mat_example, k = 2)
plot_objects(mcmc_example, target_matrix, show_clusters = TRUE)
}
\references{
Fritsch, Arno & Ickstadt, Katja. (2009). An Improved Criterion for Clustering Based on the Posterior Similarity Matrix. Bayesian Analysis. 4. \url{doi:10.1214/09-BA414}.
}
