% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_score.R
\name{bs_score}
\alias{bs_score}
\title{Calculate the Bayesian Silhouette Score}
\usage{
bs_score(mcmc_samples)
}
\arguments{
\item{mcmc_samples}{An object of class \code{mcmc} or \code{mcmc.list} containing posterior samples from a DPCD model fit using \code{\link[=run_dpcd]{run_dpcd()}}. Variables \code{x} and \code{z} must be included in the output parameters.}
}
\value{
A numeric value representing the average silhouette score across all MCMC iterations.
}
\description{
This function calculates the Bayesian Silhouette (BS) Score for a DPCD model fit using posterior MCMC samples. The BS score can be used to evaluate the clustering quality of a fit and to compare different models.
}
\details{
The Bayesian Silhouette Score is computed by calculating the silhouette score for each MCMC iteration based on the latent positions (\code{x}) and cluster assignments (\code{z}). The silhouette score measures how similar an object is to its own cluster compared to other clusters. The BS score is then obtained by averaging the silhouette scores across all MCMC iterations. Higher values of the BS score indicate a higher-quality DPCD model in terms of its clustering structure.
}
\examples{
bs_score(mcmc_example)

}
