% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{logL}
\alias{logL}
\alias{logL.UK}
\alias{logL.K}
\alias{logLpres.UK}
\alias{logLpres.K}
\title{Loglikelihood function for DNA mixture analysis.}
\usage{
logL(mixture, presence.only = FALSE, initialize = TRUE)

logL.UK(mixture, initialize = TRUE)

logL.K(mixture)

logLpres.UK(mixture, initialize = TRUE)

logLpres.K(mixture)
}
\arguments{
\item{mixture}{A \code{\link{DNAmixture}} model.}

\item{presence.only}{Set to TRUE to ignore peak heights and
evaluate the likelihood function considering peak presence and
absence (heights above and below threshold) only. Defaults to
FALSE.}

\item{initialize}{By default all entered
evidence is removed from the networks in \code{object}. Setting
\code{initialize = FALSE} should be done with care, and it is up
to the user to ensure that the likelihood being computed is meaningful.}
}
\value{
A function, which takes a \code{\link{mixpar}} model parameter as argument.
}
\description{
\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}

The function \code{logL} is used to produce a log likelihood
function for one or more traces of DNA. \code{logL} calls one of
four other likelihood functions according to whether peak heights
or only peak presence/absence is used as observations, and also
whether there are any unknown contributors in the model.
}
\note{
In the presence of unknown contributors, the returned
likelihood function relies on the Bayesian networks in the
\code{DNAmixture} object. If any evidence is entered or propagated
in these networks after creating the likelihood function, the
function will no longer compute the correct likelihood. In
particular, be ware of calling other functions in between calls to
the likelihood function, as they may change the state of the
networks.
}
\examples{
data(MC18, USCaucasian)
mixHp <- DNAmixture(list(MC18), k = 3, K = c("K1", "K2", "K3"), C = list(50),
                    database = USCaucasian)
p <- mixpar(rho = list(30), eta = list(34), xi = list(0.08),
            phi = list(c(K1 = 0.71, K3 = 0.1, K2 = 0.19)))
l <- logL(mixHp)
l(p)
}
\author{
Therese Graversen
}
