% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{curE}
\alias{curE}
\alias{curE75}
\title{Fishing at current effort levels}
\usage{
curE(x, Data, reps, plot = FALSE)

curE75(x, Data, reps, plot = FALSE)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the TAE slot(s) populated
}
\description{
Constant fishing effort set at final year of historical simulations subject
to changes in catchability determined by \code{OM@qinc} and interannual variability
in catchability determined by \code{OM@qcv}. This MP is intended to represent a
'status quo' management approach.
}
\section{Functions}{
\itemize{
\item \code{curE()}: Set effort to 100\\% of that in final year of historical simulations.

\item \code{curE75()}: Set effort to 75\\% of that in final year.

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{curE}:


\code{curE75}:
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/curE.html}{Online Documentation} for correctly rendered equations


}

\examples{
curE(1, MSEtool::Atlantic_mackerel, plot=TRUE)
curE75(1, MSEtool::Atlantic_mackerel, plot=TRUE)
}
\author{
T. Carruthers.
}
