% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_geo.R
\name{download_geo}
\alias{download_geo}
\title{Download Geodata}
\usage{
download_geo(start_year = 1998, end_year = 2022)
}
\arguments{
\item{start_year}{Integer. The starting year for downloading geodata (default is 1998).}

\item{end_year}{Integer. The ending year for downloading geodata (default is 2022).}
}
\value{
No return value. Side effect: downloads and unzips shapefiles, prints progress messages, and stores the data locally.
}
\description{
Downloads and unzips shapefiles from the official repository of the German Federal Agency for Cartography and Geodesy (BKG) for a specified range of years. The shapefiles are saved into a user-specific directory (\code{tools::R_user_dir("DEplotting", "data")}). Downloading these files may take some time, but it is necessary for other functions in this package to work properly. Already downloaded years are detected and not re-downloaded.
}
\details{
Each shapefile folder for a single year is approximately 114 MB. The total download size for all 25 years can reach approximately 2.85 GB.  
After running \code{download_geo()} once, it is recommended to run it again to verify that all selected years were downloaded successfully. Any years that are already present will be skipped, and the function will attempt to download only the missing or previously failed ones.

The shapefiles accessed by this function are provided by the German Federal Agency for Cartography and Geodesy (BKG). These data are licensed under the Data License Germany – attribution – Version 2.0 (dl-de/by-2-0). For more information, see \url{https://www.govdata.de/dl-de/by-2-0}.
}
\examples{
\donttest{
download_geo(2022, 2022)
}

}
\seealso{
\code{\link{list_codes}}, \code{\link{map_plot}}, \code{\link{load_geodata}}
}
