% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryD3mirt.R
\name{summary.D3mirt}
\alias{summary.D3mirt}
\title{Summary Method for S3 Objects of Class \code{D3mirt}}
\usage{
\method{summary}{D3mirt}(object, ..., digits = 4)
}
\arguments{
\item{object}{A S3 object of class \code{D3mirt}.}

\item{...}{Additional arguments.}

\item{digits}{The number of digits shown per estimate. The default is \code{digits = 4}.}
}
\value{
Tables containing \emph{a} and \emph{d} parameters, multidimensional discrimination (MDISC), multidimensional item difficulty (MDIFF), direction cosines, and degrees for vector angles for items.
If constructs were used in the estimation process, the summary function will also show tables for direction cosines, degrees for construct vectors, and directional discrimination (DDISC) parameters.
}
\description{
The summary method for the \code{\link[=D3mirt]{D3mirt()}} function.
}
\examples{
\dontrun{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[, 3:22] # Remove columns for age and gender

# Call D3mirt() with constructs
con <- list(c(1,2,3,4,5,6,7,8,9,10),
            c(11,12,13,14),
            c(15,17,18,19,20))
mod <- D3mirt(x, modid = c("W7Q3", "W7Q20"), con.items = con)

# Call to summary
summary(mod)

#' # Call to summary rounded off to 2 digits
summary(mod, digits = 2)
}
}
\author{
Erik Forsberg
}
