% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curriculum_graph.R
\name{plot_curriculum_graph}
\alias{plot_curriculum_graph}
\title{Plot a curriculum graph}
\usage{
plot_curriculum_graph(curriculum_graph, width = "100\%", height = 500)
}
\arguments{
\item{curriculum_graph}{A curriculum_graph object created with either
\code{\link[=curriculum_graph_from_list]{curriculum_graph_from_list()}} or
\code{\link[=curriculum_graph_from_csv]{curriculum_graph_from_csv()}}}

\item{width}{A string percentage for the width of the plot, default is "100\%".}

\item{height}{An integer representing the number of pixels for the height, default is 500.}
}
\value{
No object is returned. Rather the graph is plotted according to the specified term order in node_list. Clicking on a node will reveal its label, structural complexity (sc), centrality (cf), blocking factor (bf), and delay factor (df)
}
\description{
Plots an interactable vizNetwork visualization of the Igraph network object
representing the curriculum graph.
}
\examples{
edge_list <- data.frame(from = c(1, 3), to = c(3, 4))
node_list <-
data.frame(
 id = 1:4,
 label = c("MATH 100", "DATA 101", "MATH 101", "MATH 221"),
 term = c(1, 1, 2, 2)
)
C <- curriculum_graph_from_list(node_list,edge_list)
plot_curriculum_graph(C)
}
\references{
Heileman, Gregory L, Chaouki T Abdallah, Ahmad Slim, and Michael
Hickman. 2018. “Curricular Analytics: A Framework for Quantifying the Impact
of Curricular Reforms and Pedagogical Innovations.” arXiv Preprint
arXiv:1811.09676.
}
\author{
Daniel Krasnov
}
