% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoff_filter.R
\name{knockoff_filter}
\alias{knockoff_filter}
\title{Apply Knockoff Filter for Variable Selection}
\usage{
knockoff_filter(W, fdr = 0.1, offset = 1)
}
\arguments{
\item{W}{Vector of W statistics from \code{\link{calculate_w_statistics}}}

\item{fdr}{Target false discovery rate (default: 0.1)}

\item{offset}{Offset parameter for knockoff filter (default: 1)}
}
\value{
Vector of indices of selected variables
}
\description{
Applies the knockoff filter to select variables while controlling the
false discovery rate (FDR) at a specified level.
}
\examples{
\donttest{
# Generate some example W statistics
W <- c(2.1, -0.5, 3.8, -1.2, 4.5, 0.3, -2.1, 1.9)

# Apply knockoff filter
selected <- knockoff_filter(W, fdr = 0.1)
print(selected)  # Indices of selected variables
}
}
