% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.adaptive.R
\name{CovEst.adaptive}
\alias{CovEst.adaptive}
\title{Covariance Estimation via Adaptive Thresholding}
\usage{
CovEst.adaptive(X, thr = 0.5, nCV = 10, parallel = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix where each row is an observation.}

\item{thr}{user-defined threshold value. If it is a vector of regularization values, it automatically selects one that minimizes cross validation risk.}

\item{nCV}{the number of repetitions for 2-fold random cross validations for each threshold value.}

\item{parallel}{a logical; \code{TRUE} to use half of available cores, \code{FALSE} to do every computation sequentially.}
}
\value{
a named list containing: \describe{
\item{S}{a \eqn{(p\times p)} covariance matrix estimate.}
\item{CV}{a dataframe containing vector of tested threshold values(\code{thr}) and corresponding cross validation scores(\code{CVscore}).}
}
}
\description{
Cai and Liu (2011) proposed an adaptive variant of Bickel and Levina (2008) - \code{\link{CovEst.hard}}. The idea of \emph{adaptive thresholding} is
to apply thresholding technique on correlation matrix in that it becomes \emph{adaptive} in terms of each variable.
}
\examples{
## generate data from multivariate normal with Identity covariance.
pdim <- 5
data <- matrix(rnorm(10*pdim), ncol=pdim)

## apply 4 different schemes
#  mthr is a vector of regularization parameters to be tested
mthr <- seq(from=0.01,to=0.99,length.out=10)

out1 <- CovEst.adaptive(data, thr=0.1)  # threshold value 0.1
out2 <- CovEst.adaptive(data, thr=0.5)  # threshold value 0.5
out3 <- CovEst.adaptive(data, thr=0.1)  # threshold value 0.9
out4 <- CovEst.adaptive(data, thr=mthr) # automatic threshold checking

## visualize 4 estimated matrices
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(out1$S[,pdim:1], col=gray((0:100)/100), main="thr=0.1")
image(out2$S[,pdim:1], col=gray((0:100)/100), main="thr=0.5")
image(out3$S[,pdim:1], col=gray((0:100)/100), main="thr=0.9")
image(out4$S[,pdim:1], col=gray((0:100)/100), main="automatic")
par(opar)

}
\references{
\insertRef{cai_adaptive_2011}{CovTools}
}
