% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cyclic_matrix}
\alias{cyclic_matrix}
\title{Create a Cyclic Matrix for a Given Vector.}
\usage{
cyclic_matrix(v)
}
\arguments{
\item{v}{A numeric vector.}
}
\value{
A symmetric matrix.
}
\description{
This helper function creates a symmetric matrix from a given vector \eqn{v}.
}
\details{
This function creates a symmetric matrix for a given vector \eqn{v}.
If \eqn{v = \{v_{0}, v_{1} , \dots , v_{N-1} , v_{N} \},} then the symmetric matrix will has the form
\deqn{\left[ {\begin{array}{ccccc}
v_{0}     & v_{1}     & \cdots & v_{N - 1} & v_{N}     \\
v_{1}     & v_{0}     & \cdots & v_{N - 2} & v_{N - 1} \\
\vdots    & \vdots    & \ddots & \vdots    & \vdots    \\
v_{N - 1} & v_{N- 2}  & \cdots & v_{0}     & v_{1}     \\
v_{N}     & v_{N - 1} & \cdots & v_{1}     & v_{0}     \\
\end{array}} \right]
}
}
\examples{
v <- c(1, 2, 3)
cyclic_matrix(v)
}
