% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_pvalues.R
\name{adjust_pvalues}
\alias{adjust_pvalues}
\title{Compute Fisher-Adjusted P-Values for Multiple Testing}
\usage{
adjust_pvalues(ls, bw = NULL)
}
\arguments{
\item{ls}{List of "null_rand" objects}

\item{bw}{Histogram bin width (optional)}
}
\value{
Vector with adjusted p-values
}
\description{
Adjusts p-values obtained from multiple comparisons. Computes Fisher-Adjusted
P-Values utilizing randomization-based method (Lee et al., 2017).
}
\details{
Argument "ls" must have a "null_rand" object for each p-value that needs to
be adjusted.

Function plots joint p-value distribution.
}
\examples{
y = sample_data$turn_angle
w = sample_data$w
n_one = create_null_rand(y, w, sample_matrix, test_stat = c("t"))
y = sample_data$turn_angle
w = sample_data$w
fun = function(x,y){
  return(invisible(ks.test(x,y)$statistic))
}
n_two = create_null_rand(y, w, sample_matrix, fun = fun,
alternative = c("greater"))
adjust_pvalues(list(n_one,n_two))
}
\references{
\doi{10.5705/ss.202016.0116}
}
