% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_sampler_posterior.R
\name{gibbs.sampler.posterior}
\alias{gibbs.sampler.posterior}
\title{Continuous Response Posterior Probability.}
\usage{
gibbs.sampler.posterior(
  X,
  Y,
  beta.mean,
  beta.precision,
  shape,
  rate,
  b.sim,
  b.burnin,
  phi.0,
  prob,
  factor.no.2way = NA,
  colnames.pick = NA,
  seed = NA,
  verbose = TRUE
)
}
\arguments{
\item{X}{Design matrix for the test (matrix of indicator functions defining
which model parameters are active in each test event).}

\item{Y}{A vector of the responses from the test.}

\item{beta.mean}{Mean vector of the multivariate normal distribution
(or the mean of each of the priors on the model parameters), ordered
the same as the columns of the design matrix, X. It also serves as
the initialization for the model parameters.}

\item{beta.precision}{Precisions of the multivariate normal distribution
(precision of each of the priors on the model parameters), corresponding
to the beta.mean values.}

\item{shape}{Hyperparameter alpha for gamma prior on the precision of the ANOVA model, tau.}

\item{rate}{Hyperparameter beta for gamma prior on the precision of the ANOVA model, tau.}

\item{b.sim}{Number of conditional posterior draws used in analysis
for each non-conditional draw.}

\item{b.burnin}{Number of burn-in samples for the conditional posterior.}

\item{phi.0}{Threshold value the parameter of interest (BMM) must obtain
(i.e., BBM > \code{phi.0}).}

\item{prob}{Matrix or dataframe of the "likelihood of encountering" (or probability of seeing a
factor level); it is a two column matrix (or dataframe), where the first column identifies the
factor numerically and the second column defines the probability of seeing each
factor level.}

\item{factor.no.2way}{Optional vector of model parameters (as defined by prob)
that are not incorporated in the two way interactions for the model.}

\item{colnames.pick}{Optional vector of model parameter names in the same order
as in the design matrix to label the returned dataframe columns.}

\item{seed}{Optional selection which will create a reproducible result from the function.}

\item{verbose}{Allows suppression of sampler progress printing in console.}
}
\value{
Returns a list with three elements:
\describe{
\item{\code{pp}}{This value will be NA since this function only calculates the posterior}
\item{\code{posterior}}{The full dataframe of non-conditional posterior draws}
\item{\code{indicator}}{This value will be NA since this function only calculates the posterior}
}
Printing the result object will display the predicted probability result.
}
\description{
\code{gibbs.sampler.posterior} obtains the ContRespPP method for obtaining the posterior (i.e., all
observations have been seen, and this reverts to a traditional Bayesian analysis) using base R
functions, drastically increasing the computational time required to obtain predictive draws.
}
