% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_distance.R
\name{ext_distance}
\alias{ext_distance}
\title{Extrinsic evaluation distance matrix creation}
\usage{
ext_distance(comm_df, variant = c("NMI", "adj_RI", "purity"))
}
\arguments{
\item{comm_df}{a data frame whose columns are different partitions. All
partitions must have the same set of nodes in order for this function to work
and this data frame should exclude a node ID column for ease of computation.}

\item{variant}{a string in ('NMI', 'Adj_RI', 'purity') that calculates different
extrinsic cluster evaluation metrics.}
}
\value{
A m x m (m is the number of partitions) extrinsic evaluation distance
matrix to be used as input for the kernel function
}
\description{
Description of the extrinsic evaluation distance matrix creation function.
}
\details{
This function creates a distance matrix using the community output values
from any community detection algorithm, such as the hierarchical multimodal
spinglass algorithm. Because extrinsic evaluation metrics for clustering
algorithms use the underlying idea of similarity, distance is calculated as
(1-similarity). The use of distance ensures that the distance matrix will be
positive and semi-definite, a requirement for its use in the kernel function.
}
\examples{
x <- c(2,2,3,1,3,1,3,3,2,2,1,1)
y <- c(3,3,2,1,1,1,1,2,2,3,2,3)
z <- c(1,1,2,3,2,3,2,1,1,2,3,3)

xyz_comms <- data.frame(x_comm = x, y_comm = y, z_comm = z)
ext_distance(xyz_comms, variant = 'NMI')
ext_distance(xyz_comms, variant = 'adj_RI')
ext_distance(xyz_comms, variant = 'purity')

}
\seealso{
\code{\link{adj_RI}}, \code{\link{NMI}}, and \code{\link{purity}}
}
