% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_mult_spin.R
\name{hms}
\alias{hms}
\title{Hierarchical multimodal spinglass algorithm}
\usage{
hms(input_net, spins, alpha, coolfact, tol, max_layers)
}
\arguments{
\item{input_net}{a \code{spinglass_net} object (see
\code{\link{matrix_to_df}} for more details)}

\item{spins}{an integer indicating the maximum number of spins, or
communities, that can be used}

\item{alpha}{a double parameter balancing the use of the guidance matrix in
modularity calculation}

\item{coolfact}{a double parameter that indicates how quickly (or slowly) to
cool the heatbath algorithm, typically set to be 0.95-0.99}

\item{tol}{a double parameter that indicates the tolerance level of accepting
the proposed changes within a temperature; at the end of each sweep, the number
of proposed changes to the partition is assessed to see if it exceeds a threshold
determined as a function of tol and spins, typically set to be 0.01-0.05}

\item{max_layers}{an integer parameter that specifies the maximum number of
layers of communities within the network}
}
\value{
a list of two components: comm_layers_tree, a dataframe whose first
column is the node id and all subsequent columns are the partitioning of the
nodes to communities across the number of pre-specified layers; and
best_hamiltonian, a vector of the optimized Hamiltonian values for each
run of the algorithm
}
\description{
Description of the hierarchical multimodal spinglass algorithm function.
}
\details{
This is the main function of the algorithm. After running checks on the input
parameters, the algorithm begins on the first layer of the network, finding
the optimal configuration of nodes to communities using the heatbath
algorithm. Once the community assignments have been finalized, the set of
nodes within each of these communities is broken up and become their own
subnetworks, on which the algorithm is applied again to get further
subnetwork community assignments. This continues until the maximum number of
layers is reached.
}
\examples{

hms_object <-
  hms(input_net = SBM_net, 
      spins = 4,
      alpha = 0,
      coolfact = 0.90,
      tol = 0.05,
      max_layers = 1)

str(hms_object)
str(hms_object$comm_layers_tree)
str(hms_object$net)

identical(SBM_net, hms_object$net)
hms_object$net$vertexes

community_plot(hms_object)
  
}
\seealso{
\code{\link{matrix_to_df}}, \code{\link{community_plot}}
}
