% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WS.R
\name{WS}
\alias{WS}
\title{WS: Wilson Score Method for Simultaneous Confidence Intervals}
\usage{
WS(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed cell counts corresponding to a
categorical dataset. All values must be non-negative.}

\item{alpha}{Desired statistical significance level}
}
\value{
Prints the original and adjusted confidence intervals for each category,
along with the volume (product of interval widths).
}
\description{
Computes Wilson score-type simultaneous confidence intervals for multinomial
proportions. The Wilson method improves upon the Wald interval by ensuring
better coverage probabilities, especially for small samples or proportions
near 0 or 1.
}
\details{
This approach adjusts both the center and width of the confidence interval
to account for the sampling distribution of proportions, leading to
non-symmetric intervals that perform better than the simple Wald intervals.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
WS(y, z)

}
\references{
Wilson, E. B. (1927).
*Probable Inference, the Law of Succession, and Statistical Inference.*
Journal of the American Statistical Association, **22**, 209–212.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALD}}, \code{\link{WALDCC}}, \code{\link{SG}}
}
\author{
Dr. M. Subbiah
}
