% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMDE.R
\name{BMDE}
\alias{BMDE}
\title{BMDE: Multinomial–Dirichlet Equal Prior Bayesian Method}
\usage{
BMDE(x, p)
}
\arguments{
\item{x}{Integer vector of observed counts. Must be non-negative.}

\item{p}{Numeric scalar or vector specifying Dirichlet prior parameters. Must be non-negative.}
}
\value{
Prints posterior means, lower and upper 95% credible limits for each category,
and the product of the interval widths (volume).
}
\description{
Computes the Bayesian Dirichlet posterior for a multinomial vector
with equal prior parameters and returns the posterior mean, 95% credible intervals,
and the volume of those intervals.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 1
BMDE(y, z)

}
