% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.clusbootglm.R
\name{predict.clusbootglm}
\alias{predict.clusbootglm}
\title{Predict method for cluster bootstrap GLM}
\usage{
\method{predict}{clusbootglm}(
  object,
  stat = mean,
  newdata = NULL,
  interval = FALSE,
  confint.level = NULL,
  keep.bootstrap.matrix = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{clusbootglm}.}

\item{stat}{Center statistic of choice. Defaults to \code{mean}.}

\item{newdata}{Optional data frame in which to look for variables with which to predict. If omitted, observations from the data value of the \code{clusbootglm} object are used.}

\item{interval}{Boolean, indicating whether a confidence interval should be returned.}

\item{confint.level}{Level of the confidence interval. Should be in [0, 1]. Defaults to .95 when \code{interval} = TRUE.}

\item{keep.bootstrap.matrix}{Boolean, indicating whether the n * B bootstrap matrix should be returned. If TRUE, the return value for \code{predict.clusbootglm} becomes a list (see 'Value' below).}

\item{...}{additional arguments passed to the function defined in the \code{stat} parameter.}
}
\value{
If \code{keep.bootstrap.matrix} is FALSE, \code{predict.clusbootglm} returns a matrix, containing the predicted values by evaluating the regression parameters 
in \code{newdata} (which defaults to the data value in \code{object}).
If \code{keep.bootstrap.matrix} is TRUE, the function returns a list containing: 
\item{predictions}{Matrix containing predicted values by evaluating the regression parameters in \code{object$data}.}
\item{bootstrapmatrix}{A n * B matrix with the predictions within all bootstrap samples.}
}
\description{
Returns the predicted values for an \code{clusbootglm} object.
}
\examples{
\dontrun{
medication <- medication[medication$time \%\% 1 == 0,]
medication$time <- as.factor(medication$time)
set.seed(1)
model.1 <- clusbootglm(pos~time*treat, clusterid = id, data = medication)
predict(object = model.1, interval = TRUE)}
}
\author{
Mathijs Deen
}
