% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_consistency}
\alias{element_consistency}
\title{Element-Wise Consistency Between a Set of Clusterings}
\usage{
element_consistency(
  clustering_list,
  alpha = 0.9,
  r = 1,
  rescale_path_type = "max",
  ppr_implementation = "prpack",
  dist_rescaled = FALSE,
  row_normalize = TRUE
)
}
\arguments{
\item{clustering_list}{The list of clustering results, each of which is either:
\itemize{
\item A numeric/character/factor vector of cluster labels for each element.
\item A samples x clusters matrix/Matrix::Matrix of nonzero membership values.
\item An hclust object.
}}

\item{alpha}{A numeric giving the personalized PageRank damping factor;
1 - alpha is the restart probability for the PPR random walk.}

\item{r}{A numeric hierarchical scaling parameter.}

\item{rescale_path_type}{A string; rescale the hierarchical height by:
\itemize{
\item "max" : the maximum path from the root.
\item "min" : the minimum path form the root.
\item "linkage" : use the linkage distances in the clustering.
}}

\item{ppr_implementation}{Choose a implementation for personalized
page-rank calculation:
\itemize{
\item "prpack": use PPR algorithms in igraph.
\item "power_iteration": use power_iteration method.
}}

\item{dist_rescaled}{A logical: if TRUE, the linkage distances are linearly
rescaled to be in-between 0 and 1.}

\item{row_normalize}{Whether to normalize all rows in clustering_result
so they sum to one before calculating ECS. It is recommended to set this to
TRUE, which will lead to slightly different ECS values compared to clusim.}
}
\value{
A vector containing the element-wise consistency. If
\code{calculate_sim_matrix} is set to \code{TRUE}, the element similarity matrix
will be returned as well.
}
\description{
Inspect the consistency of a set of clusterings by calculating
their element-wise clustering consistency (also known as element-wise frustration).
}
\examples{
# cluster across 20 random seeds
clustering.list <- lapply(1:20, function(x) kmeans(mtcars, centers = 3)$cluster)
element_consistency(clustering.list)
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
