% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumEventsSub.OneArm.R
\name{NumEventsSub.OneArm}
\alias{NumEventsSub.OneArm}
\title{Calculate the expected number of events or number of subjects enrolled in a one-arm clinical trial}
\usage{
NumEventsSub.OneArm(
  N = NULL,
  d = NULL,
  l = NULL,
  gamma = NULL,
  s = NULL,
  m = NULL,
  alpha = NULL,
  nu = NULL,
  design1 = NULL
)
}
\arguments{
\item{N}{Number of subjects plan to enrolled}

\item{d}{expected number of events observed at time \code{l}}

\item{l}{observation time}

\item{gamma}{parameter of the exponential distribution of censoring time}

\item{s}{enrollment period}

\item{m}{maximum follow-up for a single subject}

\item{alpha}{shape parameter of weibull survival distribution}

\item{nu}{scale parameter of weibull survival distribution}

\item{design1}{a list containing all the above parameters for one-arm design}
}
\value{
This function returns a list containing all design parameters as the same with input parameters of this function.
}
\description{
Calculate the expected number of events or number of subjects enrolled in a one-arm clinical trial
}
\examples{
# Calculate the expected number of events in a one-arm clinical trial
NumEventsSub.OneArm(N=100,d=NULL,l=3,gamma=0.1,s=12,m=6,alpha=1,nu=20)

}
