% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv23_random_effect_coef.R
\name{cv23_random_effect_coef}
\alias{cv23_random_effect_coef}
\title{Extract Random Effect Coefficients}
\usage{
cv23_random_effect_coef(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the data.}

\item{residue_col}{The name of the residue column.}

\item{cleaning_event_col}{The name of the column used for random effects grouping.}
}
\value{
A data frame with the random effect coefficients and standard deviations.
}
\description{
This function fits a Poisson mixed-effects model with a specified random effect 
and extracts the random effect coefficients and their standard deviations.
}
\examples{
re_coefs <- cv23_random_effect_coef(data=Eq_Mic, residue_col="Mic", 
cleaning_event_col="CleaningEvent")

}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
