% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv12_kde_Ppu.R
\name{cv12_kde_ppu}
\alias{cv12_kde_ppu}
\title{Calculate PPU using KDE density estimation}
\usage{
cv12_kde_ppu(
  data,
  residue_col,
  cleaning_event_col,
  usl_col,
  n_bootstrap = 1000
)
}
\arguments{
\item{data}{The dataset containing the columns specified in other parameters.}

\item{residue_col}{The name of the column containing residue data.}

\item{cleaning_event_col}{The name of the column containing cleaning event data (unused).}

\item{usl_col}{The name of the column containing USL values.}

\item{n_bootstrap}{The number of bootstrap samples to use.}
}
\value{
A dataframe with the estimated PPU and its 95% confidence interval.
}
\description{
Calculate PPU using KDE density estimation
}
\examples{
 Eq_DAR <- cv03_usl_unification(data = Eq_DAR, cleaning_event_col = "CleaningEvent", 
residue_col = "DAR", usl_col = "USL")
cv12_kde_ppu(data = Eq_DAR, residue_col = "DAR_Pct", cleaning_event_col = "CleaningEvent",
 usl_col = "USL_Pct", n_bootstrap = 1000)
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
