% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_costmatrix_to_stategraph.r
\name{convert_costmatrix_to_stategraph}
\alias{convert_costmatrix_to_stategraph}
\title{Convert a costmatrix to a minimal state graph}
\usage{
convert_costmatrix_to_stategraph(costmatrix)
}
\arguments{
\item{costmatrix}{An object of class \code{costMatrix}.}
}
\value{
An object of class \code{stateGraph}.
}
\description{
Given a costmatrix, returns the smallest possible state graph (fewest arcs).
}
\details{
A costmatrix summarises all possible state-to-state transition costs and hence each entry can also be considered as an arc of a directed state graph. However, many of these arcs could be removed and a complete description of the graph still be provided. For example, the diagonal (any transition from a state to itself - a loop) can be removed, as can any arc with infinite cost (as this arc would never be traversed in practice). Finally, some arcs are redundant as indirect paths already represent the same cost.

As an example, we can consider the linear ordered costmatrix:

\preformatted{    -------------
    | 0 | 1 | 2 |
-----------------
| 0 | 0 | 1 | 2 |
-----------------
| 1 | 1 | 0 | 1 |
-----------------
| 2 | 2 | 1 | 0 |
-----------------}

A maximum directed graph representation would thus be:

\preformatted{----------------------
| from | to | weight |
----------------------
|   0  | 0  |   0    |
----------------------
|   0  | 1  |   1    |
----------------------
|   0  | 2  |   2    |
----------------------
|   1  | 0  |   1    |
----------------------
|   1  | 1  |   0    |
----------------------
|   1  | 2  |   1    |
----------------------
|   2  | 0  |   2    |
----------------------
|   2  | 1  |   1    |
----------------------
|   2  | 2  |   0    |
----------------------}

But the following description is still complete, and minimal:

\preformatted{----------------------
| from | to | weight |
----------------------
|   0  | 1  |   1    |
----------------------
|   1  | 0  |   1    |
----------------------
|   1  | 2  |   1    |
----------------------
|   2  | 1  |   1    |
----------------------}

This function effectively generates the latter (the minimal directed graph representation as a matrix of arcs).
}
\examples{

# Make a six-state unordered character costmatrix:
unordered_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state= 5,
  character_type = "unordered"
)

# Find the minimal directed graph representation:
convert_costmatrix_to_stategraph(costmatrix = unordered_costmatrix)

# Make a six-state ordered character costmatrix:
ordered_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state= 5,
  character_type = "ordered"
)

# Find the minimal directed graph representation:
convert_costmatrix_to_stategraph(costmatrix = ordered_costmatrix)

# Make a six-state stratigraphic character costmatrix:
stratigraphic_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state= 5,
  character_type = "stratigraphy",
  state_ages = c(103, 91.4, 78.2, 73.4, 66.0, 59.7)
)

# Find the minimal directed graph representation:
convert_costmatrix_to_stategraph(costmatrix = stratigraphic_costmatrix)

}
\seealso{
\link{convert_adjacency_matrix_to_costmatrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
