% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_counter_weight.R
\name{compute_counter_weight}
\alias{compute_counter_weight}
\title{Compute counter or weight of data samples}
\usage{
compute_counter_weight(gps_obj, ci_appr, nthread = 1, ...)
}
\arguments{
\item{gps_obj}{A gps object that is generated with \code{estimate_gps} function.
If it is provided, the number of iteration will forced to 1 (Default: NULL).}

\item{ci_appr}{The causal inference approach. Possible values are:
\itemize{
\item "matching": Matching by GPS
\item "weighting": Weighting by GPS
}}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}

\item{...}{Additional arguments passed to different models.}
}
\value{
Returns a counter_weight (cgps_cw) object that includes \code{.data} and \code{params}
attributes.
\itemize{
\item \code{.data}: includes \code{id} and \code{counter_weight} columns. In case of \code{matching}
the \code{counter_weight} column is integer values, which represent how many times
the provided observational data was mached during the matching process. In
case of \code{weighting} the column is double values.
\item \code{params}: Include related parameters that is used for the process.
}
}
\description{
Computes counter (for matching approach) or weight (for weighting) approach.
}
\details{
\subsection{Additional parameters}{
\subsection{Causal Inference Approach (ci_appr)}{
\itemize{
\item if ci_appr = 'matching':
\itemize{
\item \emph{bin_seq}: A sequence of w (treatment) to generate pseudo population.
If \code{NULL} is passed the default value will be used, which is
\code{seq(min(w)+delta_n/2,max(w), by=delta_n)}.
\item \emph{dist_measure}: Matching function. Available options:
\itemize{
\item l1: Manhattan distance matching
}
\item \emph{delta_n}: caliper parameter.
\item \emph{scale}: a specified scale parameter to control the relative weight that
is attributed to the distance measures of the exposure versus the GPS.
}
}
}

}
}
\examples{
\donttest{
m_d <- generate_syn_data(sample_size = 100)
gps_obj <- estimate_gps(.data = m_d,
                        .formula = w ~ cf1 + cf2 + cf3 + cf4 + cf5 + cf6,
                        gps_density = "normal",
                        sl_lib = c("SL.xgboost"))

cw_object <- compute_counter_weight(gps_obj = gps_obj,
                                    ci_appr = "matching",
                                    bin_seq = NULL,
                                    nthread = 1,
                                    delta_n = 0.1,
                                    dist_measure = "l1",
                                    scale = 0.5)
}
}
