% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locatePathEnd.R
\name{locatePathEnd}
\alias{locatePathEnd}
\title{Get coordinates of the end of the path on a CT scan image}
\usage{
locatePathEnd(im, pithCoord)
}
\arguments{
\item{im}{CT scan image}

\item{pithCoord}{X,Y coordinates of the pith}
}
\value{
Coordinates of the end of the path
}
\description{
Get coordinates of the end of the path on a CT scan image
}
\examples{

library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual
# not run - endPath <- locatePathEnd(im_dens, pith_coord) # using the image

}
