% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPCAT.R
\name{CPCAT}
\alias{CPCAT}
\title{Performs the closure principle computational approach test (CPCAT).}
\usage{
CPCAT(z, M = 10000)
}
\arguments{
\item{z}{The data set to be used. One column of z must contain the numeric Poisson data and one must contain the factor variable. The first level of the factor variable is assumed to be the control group. Factor levels (i.e., groups) should be in ascending order (e.g. increasing concentration of a test substance). If the data frame contains more than one numeric column and/or more than one factor variable the CPCAT is applied to the first numeric column and the corresponding Poisson data are grouped according the first factor variable.}

\item{M}{The number of parametric bootstrap simulations. Defaults to M=10000.}
}
\value{
A p-value for each main hypotheses H_0i: mu_0=mu_i "control vs. treatment i".
}
\description{
Performs the closure principle computational approach test (CPCAT).
}
\examples{
data(testdata)
CPCAT(testdata)
CPCAT(z=testdata)
CPCAT(z=testdata, M=1000)
}
