% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degenScore.R
\name{degenScore}
\alias{degenScore}
\title{degenScore}
\usage{
degenScore(A)
}
\arguments{
\item{A}{A numeric matrix of subject-mode loadings (dimensions: subjects x components).}
}
\value{
A numeric scalar representing the maximum absolute off-diagonal
Tucker congruence between components.
}
\description{
Computes the maximum absolute off-diagonal Tucker congruence coefficient
between subject-mode components in an ACMTF model. This metric serves as a
diagnostic tool to detect potential degeneracy in the subject-mode loadings.
}
\details{
A high \code{degenScore} (e.g., > 0.85) indicates that two or more components
in the subject mode are highly similar, suggesting a possible degeneracy or
lack of uniqueness. A low value (e.g., < 0.3) indicates well-separated components.
}
\examples{
# Example: Compute degenScore for a random loading matrix
A <- matrix(rnorm(100), nrow = 10, ncol = 10)
degenScore(A)

}
