% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_MM_matrix.R
\name{sim_MM_matrix}
\alias{sim_MM_matrix}
\title{Simulation of MM matrix based}
\usage{
sim_MM_matrix(W, m, ord = 3, w_ord, id_vec, excess_areas = FALSE, red_areas)
}
\arguments{
\item{W}{Symmetric adjacency matrix of size \code{n}}

\item{m}{Integer. Number of membership to simulate}

\item{ord}{Integer. Maximum order of neighbours to be used to simulate the
memberships based on the adjacency matrix \code{W}}

\item{w_ord}{A vector of length \code{ord} that specifies the weights of each
order of neighbours}

\item{id_vec}{Vector of zeros and ones of length \code{n}. Defaults to
a vector of ones. It indicates whether an area is included in the
simulation of a membership}

\item{excess_areas}{if different from FALSE it indicates the indices of the
areas to reuse in simulating memberships, whenever \code{m} > \code{n}. It defaults to
FALSE, and if omitted randomly selects without replacement
(if \code{m} - \code{n} <= \code{n}, otherwise with replacement) a subset of areas}

\item{red_areas}{vector of indices of areas to use if \code{m} < \code{n}}
}
\value{
an m x n matrix of weights
}
\description{
\code{sim_MM_matrix} returns a multiple membership matrix simulated based on an
adjacency matrix according to the method described in
}
\examples{
set.seed(455)

#---- Load data
data(W_sel)
## Number of areas
n <- nrow(W_sel)
## Number of memberships
m <- 153

#---- Simulate MM matrix
w_ord <- c(.5, .35, .15) # Weight of each neighbours orders
ord <- length(w_ord) - 1 # Order of neighbours to include
H_sel_sim <- sim_MM_matrix(
  W = W_sel, m = m, ord = ord, w_ord = w_ord, id_vec = rep(1, nrow(W_sel))
)
}
\references{
Marco Gramatica. Silvia Liverani. Peter Congdon.
"Structure Induced by a Multiple Membership Transformation on the Conditional
Autoregressive Model." Bayesian Analysis Advance Publication 1 - 25, 2023.
https://doi.org/10.1214/23-BA1370
}
