% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_SRM_time_varying.R
\name{ca_SRM_time_varying}
\alias{ca_SRM_time_varying}
\title{Time varying Simple retention model
Estimates retention rate using logistic regression and the simple regression model
Mostly used for contractual models where there are clear opportunities for cancellation.  
Could be used in non-contractional
situations although the cancellation opportunities should be defined.  Not recommended
for use with services that consumers use rotating-door style.  Use the migration model there.}
\usage{
ca_SRM_time_varying(df_logistic, reference_level = 12, maxT = 12)
}
\arguments{
\item{df_logistic}{A data frame, formatted for logistic regression.
1 row for each customer id/timeperiod.  1/0 for purchase.}

\item{reference_level}{All coefficients will be judged relevant to the reference level.  It defaults to 
time period 12.  (Note interpretation will change based on how T is formulated.)}

\item{maxT}{The number of timeperiods to build.}
}
\value{
Returns logistic model results (the glm model)
}
\description{
Time varying Simple retention model
Estimates retention rate using logistic regression and the simple regression model
Mostly used for contractual models where there are clear opportunities for cancellation.  
Could be used in non-contractional
situations although the cancellation opportunities should be defined.  Not recommended
for use with services that consumers use rotating-door style.  Use the migration model there.
}
\examples{
library(stats)
x <- c(3, 1, 5)
df_logistic <- bigT_expand_via_apply(x)
model <- ca_SRM_time_varying(df_logistic, reference_level = 3)
}
