% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportance.R
\name{barplot.BranchGLMVI}
\alias{barplot.BranchGLMVI}
\title{Bar Plot Method for BranchGLMVI Objects}
\usage{
\method{barplot}{BranchGLMVI}(
  height,
  modified = FALSE,
  horiz = TRUE,
  decreasing = FALSE,
  which = "all",
  las = ifelse(horiz, 1, 2),
  main = NULL,
  lab = NULL,
  ...
)
}
\arguments{
\item{height}{a \code{BranchGLMVI} object.}

\item{modified}{a logical value indicating if the modified variable importance
values should be plotted.}

\item{horiz}{a logical value to indicate whether bars should be horizontal.}

\item{decreasing}{a logical value to indicate whether variables should be sorted
in decreasing order. Can use NA if no ordering is desired.}

\item{which}{which variable importance values to plot, can use a numeric vector
of indices, a character vector of names, or "all" for all variables.}

\item{las}{the style of axis labels, see \link{par} for more details.}

\item{main}{the overall title for the plot.}

\item{lab}{the title for the axis corresponding to the variable importance values.}

\item{...}{further arguments passed to \link{barplot.default}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Creates a bar plot with the L0-penalization based variable importance values.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE)

# Getting variable importance
VI <- VariableImportance(VS, showprogress = FALSE)
VI

# Plotting variable importance
oldmar <- par("mar")
par(mar = c(4, 6, 3, 1) + 0.1)
barplot(VI)
par(mar = oldmar)

}
