% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Identify_mods}
\alias{Identify_mods}
\title{Identify Data Modalities}
\usage{
Identify_mods(data, m, n, d)
}
\arguments{
\item{data}{List with components \code{X} and \code{Y} (numeric matrices).}

\item{m}{Integer. Number of rows in \code{X}.}

\item{n}{Integer. Number of rows in \code{Y}.}

\item{d}{Integer. Number of features (columns) in \code{X} (and \code{Y}).}
}
\value{
List with components:
\describe{
  \item{rearr_data}{List with rearranged \code{X}, \code{Y} after grouping features by modality.}
  \item{modality}{Integer. Number of distinct missing-data modalities.}
  \item{mod_bound}{Integer vector. Cumulative boundaries of modalities among the features.}
  \item{mod_id}{Binary matrix (N × modality) indicating, for each observation, whether each modality is observed (1) or missing (0).}
}
}
\description{
Detects modalities across the combined data (samples X and Y), rearranges variables/columns by modality, and produces identification structures used downstream for blockwise operations.
}
\keyword{internal}
