% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mammography-data.R
\docType{data}
\name{mammography-datasets}
\alias{mammography-datasets}
\alias{mammography}
\alias{observed}
\title{A mammography dataset}
\format{
The data frame \code{mammography} has 148 rows and 3 variables
\describe{
\item{ti}{True latent state of the individual (1=positive, 0=negative)}
\item{ni}{Number of mammography tests performed for each individual}
\item{si}{Number of positive mammography tests for each individual}
}

The matrix \code{observed} is a 110x148 array with the observed replicates, one column
for each individual. The rows correspond to the replicates, and the values are either 0 or 1.
}
\source{
Beam C, Conant E, Sickles E. Association of volume and volume-independent factors with accuracy in screening mammogram interpretation. \emph{JNCI.} 2003;95:282-290.
}
\usage{
data(mammography)

data(observed)
}
\description{
Data from a mammography screening program.
The dataset is not the original dataset, but an imputed dataset based on
the summary statistics available publicly.
}
\keyword{datasets}
