% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreate_diagonal_hdf5}
\alias{bdCreate_diagonal_hdf5}
\title{Create Diagonal Matrix or Vector in HDF5 File}
\usage{
bdCreate_diagonal_hdf5(
  filename,
  group,
  dataset,
  size = NULL,
  scalar = 1,
  diagonal_values = NULL,
  output_type = "matrix",
  block_size = 0L,
  compression = 6L,
  overwriteFile = NULL,
  overwriteDataset = NULL,
  threads = NULL
)
}
\arguments{
\item{filename}{Character. Path to HDF5 file}

\item{group}{Character. Group path in HDF5 file (default: "/")}

\item{dataset}{Character. Name of dataset to create}

\item{size}{Integer. Size of diagonal (auto-detected if diagonal_values provided)}

\item{scalar}{Numeric. Scalar multiplier for diagonal elements (default: 1.0)}

\item{diagonal_values}{Numeric vector. Custom diagonal values (optional)}

\item{output_type}{Character. Output format: "matrix" or "vector" (default: "matrix")}

\item{block_size}{Integer. Block size for processing (default: auto-estimate)}

\item{compression}{Integer. Compression level 0-9 (default: 6)}

\item{overwriteFile}{Logical. Overwrite file if exists (default: FALSE)}

\item{overwriteDataset}{Logical. Overwrite dataset if exists (default: FALSE)}

\item{threads}{Integer. Number of threads to use (default: auto-detect)}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the diagonal matrix (group/dataset)}
}
}
\description{
Creates a diagonal matrix or vector directly in an HDF5 file using
block-wise processing to minimize memory usage. This unified function
replaces separate diagonal and identity matrix creation functions,
providing flexible diagonal creation with automatic parameter detection.
}
\details{
This function provides flexible diagonal creation with two main modes:
\itemize{
\item Vector mode: Provide custom diagonal values
\itemize{
\item Size is automatically detected from vector length
\item Scalar acts as additional multiplier
\item Ideal for custom diagonal patterns
}
\item Scalar mode: Provide size and scalar value
\itemize{
\item Creates uniform diagonal with specified scalar
\item scalar=1.0 creates identity matrix/vector
\item Ideal for identity or uniform diagonal matrices
}
\item Output formats:
\itemize{
\item "matrix": Creates full N×N matrix (sparse, only diagonal populated)
\item "vector": Creates efficient 1×N vector with diagonal values only
}
\item Performance features:
\itemize{
\item Block-wise processing for memory efficiency
\item Optional compression with configurable levels
\item Parallel processing support for large datasets
\item Automatic block size optimization
}
}
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create identity matrix (1M x 1M)
bdCreate_diagonal_hdf5("identity.h5", "/", "I_matrix", 
                      size = 1000000, scalar = 1.0)

# Create scaled identity vector (more efficient)
bdCreate_diagonal_hdf5("scaled_id.h5", "/", "scaled_I", 
                      size = 500000, scalar = 3.14, 
                      output_type = "vector")

# Create custom diagonal matrix
custom_diag <- runif(10000)
bdCreate_diagonal_hdf5("custom.h5", "/", "my_diag",
                      diagonal_values = custom_diag,
                      scalar = 2.0, output_type = "matrix")

# Create custom diagonal vector (most efficient)
bdCreate_diagonal_hdf5("custom_vec.h5", "/", "my_diag_vec",
                      diagonal_values = custom_diag,
                      output_type = "vector")
}

}
