/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.distributions.LogNormalDistribution;
import dr.math.distributions.MultivariateDistribution;

public class MultivariateLogNormalDistribution
implements MultivariateDistribution,
GradientProvider {
    public static final String TYPE = "MultivariateLogNormal";
    private final LogNormalDistribution logNormalDistribution;
    private final int dim;

    public MultivariateLogNormalDistribution(LogNormalDistribution logNormalDistribution, int n) {
        this.logNormalDistribution = logNormalDistribution;
        this.dim = n;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.logNormalDistribution.getGradientLogDensity(object);
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += this.logNormalDistribution.logPdf(dArray[i]);
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        return new double[0][];
    }

    @Override
    public double[] getMean() {
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.logNormalDistribution.M;
        }
        return dArray;
    }

    @Override
    public String getType() {
        return null;
    }
}

