% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesPET.R
\name{predict_eventtime}
\alias{predict_eventtime}
\title{Predict the calendar time at which a target number of events is
reached from interim analysis data}
\usage{
predict_eventtime(
  N,
  E_target,
  data.enroll,
  data.eventcensor,
  blinded = TRUE,
  p_trt = NULL,
  hyperparams_enroll = list(),
  hyperparams_event = list(),
  hyperparams_censor = list(),
  chains = 4,
  iter = 4000,
  warmup = floor(iter/2),
  seed.fit = list(123),
  refresh = 0,
  control = list(list(adapt_delta = 0.95)),
  mc.cores = 1,
  assess_window = 0,
  seed.pred = 1,
  return_fit = FALSE,
  quiet = TRUE,
  return_draws = FALSE
)
}
\arguments{
\item{N}{Integer. Total planned sample size (maximum number of subjects
that can be enrolled in the trial).}

\item{E_target}{Integer. Target number of events for the final analysis.}

\item{data.enroll}{A data frame of observed enrollment information up to the
interim analysis time. Must contain the columns \code{enrollstatus},
\code{enrolltime}, and \code{interarrivaltime}. These columns follow the
conventions defined by \code{\link{generate_data}}:
\itemize{
\item \code{enrolltime}: Calendar time of enrollment for each subject,
measured from the trial time origin.
\item \code{interarrivaltime}: Time between consecutive enrollments.
\item \code{enrollstatus}: Enrollment status indicator with \code{1}
indicating an observed enrollment time and \code{0} indicating
administrative censoring of the enrollment process at the interim
analysis time.
}
The \code{No} column is optional and provides a subject index used to align
enrollment records with \code{data.eventcensor}. If missing, it is created
internally as \code{No = seq_len(nrow(data.enroll))} and a warning is returned.

All subjects in \eqn{\mathcal{B}_1} (subjects enrolled before the interim
analysis who have not yet experienced an event or random censoring,
as defined from \code{data.eventcensor}) must be
present in \code{data.enroll} and are matched by \code{No}.
When not all \code{N} subjects have enrolled by the interim analysis
(i.e., \code{nrow(data.eventcensor) < N}), \code{data.enroll} must contain
exactly one administratively censored enrollment record (\code{enrollstatus == 0}).
See \code{\link{data_example}} (element \code{example_enroll}) for a concrete
example of the expected data layout.}

\item{data.eventcensor}{A data frame of observed event and censoring outcomes at the interim
analysis time. Must contain the columns
\code{time}, \code{eventstatus}, and \code{censorstatus}.
These columns follow the conventions defined by \code{\link{generate_data}}:
\itemize{
\item \code{time}: observed follow up time, administratively censored at the interim
analysis.
\item \code{eventstatus}: event indicator (\code{1} = event, \code{0} = right-censored).
\item \code{censorstatus}: random censoring indicators \eqn{\delta_{ci}}
(\code{1} = random censoring observed,
\code{0} = no random censoring, including administrative censoring
or observed event).
}
When \code{blinded = FALSE}, the data frame must also contain the treatment assignment
indicator column \code{trt} coded as
\code{0} or \code{1}. When \code{blinded = TRUE}, \code{trt} may be present but ignored.
The \code{No} column is optional and represents a subject index used to align this data
frame with \code{data.enroll}. If missing, it is created internally as
\code{No = 1:nrow(data.eventcensor)} and a warning is returned.

Any columns other than \code{No}, \code{trt}, \code{time}, \code{eventstatus}, and
\code{censorstatus} are treated as numeric baseline covariates.
See \code{\link{fit_models}} for covariate requirements}

\item{blinded}{Logical. If \code{TRUE} (default), the interim analysis is blinded and treatment assignments
for current subjects are not observed in the data. If \code{FALSE}, the analysis
is unblinded and observed treatment assignments are used.}

\item{p_trt}{Numeric scalar in \eqn{[0,1]} giving the prespecified randomization probability
of assignment to the experimental treatment arm. Required only if \code{blinded = TRUE};
ignored otherwise. Defaults to \code{NULL}.}

\item{hyperparams_enroll}{List of prior hyperparameters for the enrollment model.
See \code{\link{fit_models}} for details.}

\item{hyperparams_event}{List of prior hyperparameters for the event-time model.
See \code{\link{fit_models}} for details.}

\item{hyperparams_censor}{List of prior hyperparameters for the censoring model.
See \code{\link{fit_models}} for details.}

\item{chains}{Number of Markov chain Monte Carlo (MCMC) chains. Defaults to \code{4}.}

\item{iter}{Number of iterations per chain (including warmup). Defaults to \code{4000}.}

\item{warmup}{Number of warmup (burn-in) iterations per chain. Must be strictly smaller
than \code{iter}. Defaults to \code{floor(iter / 2)}.}

\item{seed.fit}{Optional random seed(s) passed to \code{\link[rstan]{sampling}} for reproducibility.
Can be specified as:
\itemize{
\item a single integer or \code{NULL}, in which case the same seed
is used for all three submodels, or
\item a list of up to three integers or \code{NULL}s, recycled to length 3,
corresponding to the enrollment, censoring, and event-time models,
respectively.
}
Use \code{NULL} to allow 'Stan' to select a seed internally.
Defaults to \code{list(123)}.}

\item{refresh}{Frequency of progress updates from \code{\link[rstan]{sampling}}. Set to \code{0} (NULL) to suppress output.}

\item{control}{Sampler control settings passed to \code{\link[rstan]{sampling}} for the three
submodels (enrollment, censoring, and event-time).
Can be specified as:
\itemize{
\item a single named list of control parameters (shared across all
three submodels), or
\item a list of up to three named lists, recycled to length 3, giving
separate control settings for the enrollment, censoring, and
event-time models, respectively.
}
Typical entries include \code{adapt_delta} and \code{max_treedepth}.

Defaults to \code{list(list(adapt_delta = 0.95))}.}

\item{mc.cores}{Integer. Number of CPU cores to use when executing Markov
chains in parallel via \code{\link[rstan]{sampling}}. Defaults to \code{1}.
We recommend setting \code{mc.cores} to the maximum number of processors
supported by the available hardware and memory, up to the number of
chains.}

\item{assess_window}{Non-negative numeric. If \code{> 0},
predicted event/censor times from enrollment are recorded at the
midpoint of the assessment window in which they occur. Defaults to \code{0}.}

\item{seed.pred}{Optional integer seed for the RNG used in posterior predictive simulation. It controls
only the RNG used in posterior predictive simulation and is independent of the 'Stan' sampling seed.
Defaults to \code{list(123)}.}

\item{return_fit}{Logical; if \code{TRUE}, also return the underlying 'rstan' \code{stanfit} objects for the
enrollment, censoring, and event models. Defaults to \code{FALSE}.}

\item{quiet}{Logical. If \code{TRUE} (default), suppress messages and diagnostic warnings
from 'Stan' during model fitting. Useful for large simulation studies.}

\item{return_draws}{Logical. If \code{TRUE}, also return the posterior draws from the fitted submodels
as \code{result$draws}. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{"BayesPET_predtime"}, which is a named list with components:
\itemize{
\item \code{prediction}: A numeric vector of length \code{S},
where \code{S} is the number of posterior draws from the fitted models.
Each element is a posterior predictive draw of the calendar time at
which the cumulative number of events reaches \code{E_target}.
Values may be \code{Inf} if fewer than \code{E_target} events occur in that draw.

\item \code{fit}: Present only if \code{return_fit = TRUE}. A list of 'rstan' \code{stanfit} objects with
components \code{enroll}, \code{censor}, and \code{event}, corresponding to the enrollment,
censoring, and event-time models, respectively.

\item \code{draws}: Present only if \code{return_draws = TRUE}. A list of posterior draws of model
parameters produced by the fitted submodels.
This includes posterior draws from the enrollment, event-time, and censoring models.

\item \code{call}: The function call used to generate this object.
}
Methods include \code{\link{print}}, \code{\link{summary}}, and \code{\link{plot}}.
}
\description{
Fits enrollment, event-time, and random censoring models to data observed at the
interim analysis and predicts the calendar time at which the cumulative number
of events reaches \code{E_target}.
}
\details{
The function fits three components in sequence using \code{\link{fit_models}}:
an enrollment model, an event-time model, and a random censoring model, all based on
data observed at the interim analysis. It then performs posterior predictive simulation
for two groups of subjects:
\itemize{
\item \eqn{\mathcal{B}_1}: subjects enrolled before the interim analysis who have not
experienced an event or random censoring by the interim data cut;
\item \eqn{\mathcal{B}_2}: subjects not yet enrolled by the interim analysis.
}
For each posterior draw, the function estimates the calendar time
at which the cumulative number of events reaches \code{E_target}.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
## Reduced number of chains and iterations compared to defaults
## to keep the example computationally manageable.
pred <- predict_eventtime(
  N = 200,
  E_target = 150,
  data.enroll = data_example$example_enroll,
  data.eventcensor = data_example$example_eventcensor,
  blinded = TRUE,
  p_trt = 0.5,
  chains = 2,
  iter = 2000,
  assess_window = 2,
  seed.fit = 1,
  seed.pred = 2,
  return_fit = TRUE,
  return_draws = TRUE,
  quiet = TRUE
)

print(pred)
summary(pred)
plot(pred)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET prediction: \code{\link{plot.BayesPET_predtime}}, \code{\link{print.BayesPET_predtime}}, \cr
\code{\link{summary.BayesPET_predtime}}
}
