#' Example trial datasets for fitting Stan models and predicting event times
#'
#' @description
#' \code{data_example} is a simulated set of trial datasets designed to illustrate
#' a complete analysis workflow, including fitting enrollment and
#' survival and censoring models using interim data, and predicting the
#' calendar time at which a prespecified number of events is expected
#' to be observed.
#'
#' \strong{Context.} Consider a two-arm time-to-event trial that plans to enroll
#' \eqn{N = 200} participants, with equal randomization between the experimental
#' and control arms. An interim analysis
#' is conducted after \eqn{E_\mathrm{cutoff} = 75} events have occurred, and the
#' final analysis is planned at \eqn{E_\mathrm{target} = 150} events. Based on the
#' data available at the interim analysis, the goal is to predict the calendar
#' time (measured from the trial start) at which the cumulative number of events
#' will reach \eqn{E_\mathrm{target}}.
#'
#' The bundle contains:
#' \describe{
#'   \item{\code{example_enroll}}{Enrollment information (interarrival times and enrollment status).}
#'   \item{\code{example_eventcensor}}{Treatment assignment, follow-up time, event indicator, censoring indicator, and covariates.}
#' }
#'
#' @format
#' A named list with two data frames:
#' \describe{
#'   \item{\code{example_enroll}}{A data frame with columns:
#'     \describe{
#'       \item{No}{Integer subject identifier.}
#'       \item{interarrivaltime}{Interarrival time.}
#'       \item{enrollstatus}{Enrollment status indicator
#'         (\code{1} = enrolled, \code{0} = administratively censored).}
#'     }}
#'   \item{\code{example_eventcensor}}{A data frame with columns:
#'     \describe{
#'       \item{No}{Integer subject identifier.}
#'       \item{trt}{Treatment assignment indicator
#'         (\code{1} = experimental, \code{0} = control). This column is used
#'         for unblinded analyses and can be ignored or set to \code{NA} when fitting
#'         blinded event time models.}
#'       \item{time}{Observed follow-up time (event or censoring time, positive).}
#'       \item{eventstatus}{Event indicator (\code{1} = event, \code{0} = right-censored).}
#'       \item{censorstatus}{Random censoring indicator (\code{1} = random censoring observed,
#'         \code{0} = no random censoring, including administrative censoring or observed event).}
#'       \item{X1}{Binary covariate (0/1).}
#'       \item{X2}{Continuous covariate.}
#'     }}
#' }
#'
#' @source Simulated data.
#'
#' @usage data(data_example)
#'
#' @examples
#' data(data_example)
#' names(data_example)
#' head(data_example$example_enroll)
#' head(data_example$example_eventcensor)
"data_example"
