#' Probability mass function for truncated poisson
#'
#' @param k A scalar for the number of changes points in a cluster
#' @param lambda A scalar defining the parameter for the Truncate Poisson distribution
#'    that controls the number of change points (or its initial values)
#' @param kstar A scalar with the number maximum of change points in all clusters
#'
#' @returns `pk` returns a numerical value representing the marginal probability for a given k
#'
#' @note
#' This function is used within the Gibbs sampler, it is not expected to be used alone.
#' @seealso [gibbs_alg()]
#' @examples
#' # Hypothetical values
#' pk(k = 2, kstar = 3, lambda = 2)
#'
#' @export
#'
pk <- function(k, kstar, lambda){
  (lambda^k/factorial(k)) / sum(sapply(0:kstar,FUN=function(l){lambda^l/factorial(l)}))
}
