#' Transfor a vector with over- or underflow
#' @param x A vector with numbers
#' @param min_x A numerical value to represent the minimum value
#' to perform comparison with the actual minimum value of `x`
#' @returns
#' `logsumexp` returns each element of the vector `x` transformed using the Log-Sum-Exp trick.
#' @examples
#' # Transforming all elements in a vector using the Log-Sum-Exp trick
#' x <- c(1, 2, 3, 4, 5, 6)
#' logsumexp(x)
#' @export
logsumexp <- function(x, min_x = Inf){
  min_x <- min(min_x, min(x))
  const <- min_x / (-740)
  return(list(x = x/const, min_x = min_x))
}
