% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTdecay.R
\name{BTdecay}
\alias{BTdecay}
\title{Bradley-Terry Model with Exponential Decayed weighted likelihood}
\usage{
BTdecay(dataframe, ability, decay.rate = 0, fixed = 1, iter = 100)
}
\arguments{
\item{dataframe}{Generated using \code{\link{BTdataframe}} given raw data.}

\item{ability}{A column vector of teams ability, the last row is the home parameter.
The row number is consistent with the team's index shown in dataframe. It can be generated using \code{\link{BTdataframe}} given raw data.}

\item{decay.rate}{The exponential decay rate. Usually ranging from (0, 0.01), A larger decay rate weights more
importance to most recent matches and the estimated parameters reflect more on recent behaviour.}

\item{fixed}{A teams index whose ability will be fixed as 0. The worstTeam's index
can be generated using \code{\link{BTdataframe}} given raw data.}

\item{iter}{Number of iterations used in L-BFGS-B algorithm.}
}
\value{
List with class "BT" contains estimated abilities and convergent code, 0 stands for convergence reaches,
1 stands for convergence not reaches. If 1 is returned, we suggest that decay rate should be set lower.
Bradley-Terry model fails to model the situation when a team wins or loses in all matches.
If a high decay rate is considered, a team who only loses or wins 1 matches long time ago will also causes the same problem.
\item{ability}{Estimated ability scores}
\item{convergence}{0 stands for convergent, 1 stands for not convergent}
\item{decay.rate}{Decay rate of this model}
}
\description{
Exponential decay rate is applied to the likelihood function to achieve a better track of current abilities. When "decay.rate" is setting as 0,
this is a standard Bradley-Terry Model whose estimated parameters are equivalent to package "BradleyTerry2".
Further detailed description is attached in \code{\link{BTdecayLasso}}.
}
\details{
The standard Bradley-Terry Model defines the winning probability of i against j,
\deqn{P(Y_{ij}=1)=\frac{\exp(\tau h_{ij}^{t_{k}}+\mu_{i}-\mu_{j})}{1+\exp(\tau h_{ij}^{t_{k}}+\mu_{i}-\mu_{j})}}
\eqn{\tau} is the home parameter and \eqn{\mu_{i}} is the team i's ability score. \eqn{h_{ij}} takes 1 if team i is at home, -1 otherwise.
Given, a complete tournament's result. The objective likelihood function with an exponential decay rate is,
\deqn{\sum_{k=1}^{n}\sum_{i<j}\exp(-\alpha t_{k})\cdot(y_{ij}(\tau h_{ij}^{t_{k}}+\mu_{i}-\mu_{j})-\log(1+\exp(\tau h_{ij}^{t_{k}}+\mu_{i}-\mu_{j})))}
where n is the number of matches, \eqn{\alpha} is the exponential decay rate and \eqn{y_{ij}} takes 0 if i is defeated by j, 1 otherwise. \eqn{t_{k}} is
the time lag (time until now). 
This likelihood function is optimized using L-BFGS-B method with package \bold{optimr} and summary() function with S3 method can be applied to view the outputs.
}
\examples{
##Initializing Dataframe
x <- BTdataframe(NFL2010)

##Standard Bradley-Terry Model optimization
y <- BTdecay(x$dataframe, x$ability, decay.rate = 0, fixed = x$worstTeam)
summary(y)

##Dynamic approximation of current ability scores using exponential decayed likelihood.
##If we take decay.rate = 0.005
##Match happens one month before will weight exp(-0.15)=0.86 on log-likelihood function
z <- BTdecay(x$dataframe, x$ability, decay.rate = 0.005, fixed = x$worstTeam)
summary(z)
}
