% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spend.R
\name{spend.generalParams}
\alias{spend.generalParams}
\title{Define general parameters}
\usage{
spend.generalParams(params, func, m.x, x)
}
\arguments{
\item{params}{a vector of gamma-gamma parameters: p, q, and gamma, in that
order. p is the shape parameter for each transaction. The scale parameter
for each transaction is distributed across customers according to a gamma
distribution with parameters q (shape) and gamma (scale).}

\item{func}{name of the function calling \code{\link{dc.InputCheck}}.}

\item{m.x}{the customer's average observed transaction value in the
calibration period. May also be a vector of average observed transaction
values - see details.}

\item{x}{the number of transactions the customer made in the calibration
period. May also be a vector of frequencies - see details.}
}
\value{
That depends on \code{func}: 1. If \code{func} is \code{spend.marginal.likelihood},
the marginal distribution of a customer's average transaction value (if m.x
or x has a length greater than 1, a vector of marginal likelihoods will be
returned). 2. If \code{func} is \code{spend.LL}, the log-likelihood of the
gamma-gamma model; if m.x or x has a length greater than 1, this is a
vector of log-likelihoods. 3. If \code{func} is \code{spend.expected.value}, the
expected transaction value for a customer conditional on their transaction
behavior during the calibration period. If m.x or x has a length greater
than one, then a vector of expected transaction values will be returned.
}
\description{
This is to ensure consistency across all spend functions.
}
\details{
This function is only ever called by functions defined in the original BTYD
package, such as \code{\link{spend.LL}}, \code{\link{spend.marginal.likelihood}} or
\code{\link{spend.expected.value}} so it returns directly the output that is expected
from those calling functions.
}
\seealso{
\code{\link{spend.LL}}

\code{\link{spend.marginal.likelihood}}
}
