% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.ExpectedCumulativeTransactions}
\alias{pnbd.ExpectedCumulativeTransactions}
\title{Pareto/NBD Expected Cumulative Transactions}
\usage{
pnbd.ExpectedCumulativeTransactions(params, T.cal, T.tot, n.periods.final)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{T.cal}{length of calibration period, or a vector of calibration period
lengths.}

\item{T.tot}{End of holdout period. Must be a single value, not a vector.}

\item{n.periods.final}{Number of time periods in the calibration and holdout
periods. See details.}
}
\value{
Vector of expected cumulative total repeat transactions by all
customers.
}
\description{
Calculates the expected cumulative total repeat transactions by all customers
for the calibration and holdout periods.
}
\details{
The function automatically divides the total period up into n.periods.final
time intervals. n.periods.final does not have to be in the same unit of time
as the T.cal data. For example: - if your T.cal data is in weeks, and you
want cumulative transactions per week, n.periods.final would equal T.star. -
if your T.cal data is in weeks, and you want cumulative transactions per day,
n.periods.final would equal T.star * 7.

The holdout period should immediately follow the calibration period. This
function assume that all customers' calibration periods end on the same date,
rather than starting on the same date (thus customers' birth periods are
determined using max(T.cal) - T.cal rather than assuming that it is 0).
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

params <- c(0.55, 10.56, 0.61, 11.64)

# Returns a vector containing cumulative repeat transactions for 546 days.
# All parameters are in weeks; the calibration period lasted 39 weeks
# and the holdout period another 39.
pnbd.ExpectedCumulativeTransactions(params = params, 
                                    T.cal = cal.cbs[,"T.cal"], 
                                    T.tot = 78, 
                                    n.periods.final = 546)
}
\seealso{
\code{\link{pnbd.Expectation}}
}
