% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.summ.DCMB}
\alias{print.summ.DCMB}
\title{Prints out the summary of a DCMB object}
\usage{
\method{print}{summ.DCMB}(x,...)
}
\arguments{
\item{x}{a summary object generated from a DCMB object}

\item{...}{additional parameters to pass onto the function}
}
\value{
prints the summary of the DCMB object from which the summary object was formed
}
\description{
Prints the summary object created by summary function fro DCMB objects
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
print(summary(res3))
}

}
