% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposal.nl.r
\name{proposal.nl}
\alias{proposal.nl}
\title{NL3  model: proposal distribution.}
\usage{
proposal.nl(
  type = c("r", "d"),
  cur.par,
  prop.par,
  MCpar = get("nl.MCpar"),
  log = TRUE
)
}
\arguments{
\item{type}{One of the character strings \code{"r"} or \code{"d"}.}

\item{cur.par}{Current state of the chain.}

\item{prop.par}{Candidate parameter.}

\item{MCpar}{A list made of a single element: MCMC parameter. Re-centering parameter for the proposal distribution.}

\item{log}{Logical. Only used when \code{type =="d"}. Should the result be returned on the log-scale ?}
}
\value{
Either the (log-)density of the proposal parameter \code{prop.par}, given \code{cur.par} (if \code{type == "d"}), or a proposal  parameter (a vector), if \code{type =="r"}.
}
\description{
Density of the proposal distribution \code{q(cur.par,prop.par)} and random generator for MCMC algorithm in the NL3 model.
}
\details{
The two components of proposal parameter
\code{(alpha*, beta12*, beta13*, beta23*)}  are generated independently, under a beta distribution with mode at the current parameter's value. 

Let  \eqn{\epsilon =} \code{MCpar$eps.recentre}. To generate \code{alpha*}, given the current state \code{alpha(t)},
let \eqn{m(t) = \epsilon /2 + (1-\epsilon) * \alpha(t)} be the mean
of the Beta proposal distribution  and \eqn{\lambda = 2/\epsilon}
(a scaling constant). Then
\deqn{
\alpha^* \sim  \textrm{Beta}(\lambda m(t), (1-\lambda) m(t))}{%
\alpha *  ~ Beta(\lambda m(t), \lambda(1-m(t))).}
The  \code{betaij*}'s are generated similarly.
}
