% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BL.stepfun}
\alias{BL.stepfun}
\title{BLRPM continous stepfunction of precipitation}
\usage{
BL.stepfun(cells)
}
\arguments{
\item{cells}{\code{data.frame} of all cells containing information about occurence time, end time, intensity and storm index}
}
\value{
sfn returns stepfunction of precipitation
}
\description{
\code{BL.stepfun} calculates a continous stepfunction of precipitation from
the \code{data.frame} \code{cells}
}
\examples{
lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4
t.sim <- 240
simulation <- BL.sim(lambda,gamma,beta,eta,mux,t.sim)
stepfun <- BL.stepfun(simulation$cells)
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

